/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.loading.math;

import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_156;

public record Operator(String symbol, int precedence, Operation operation) implements Comparable<Operator>
{
    private static final Map<String, Operator> OPERATORS = new Object2ObjectOpenHashMap(14);
    private static final CharSet OPERATOR_SYMBOLS = (CharSet)class_156.method_654((Object)new CharOpenHashSet(15), set -> set.addAll(Arrays.asList(Character.valueOf('?'), Character.valueOf(':'), Character.valueOf(','))));
    private static int LONGEST_OPERATOR;
    public static final Operator ADD;
    public static final Operator SUB;
    public static final Operator MUL;
    public static final Operator DIV;
    public static final Operator MOD;
    public static final Operator POW;
    public static final Operator AND;
    public static final Operator OR;
    public static final Operator LT;
    public static final Operator LTE;
    public static final Operator GT;
    public static final Operator GTE;
    public static final Operator EQUAL;
    public static final Operator NOT_EQUAL;
    public static final Operator ASSIGN_VARIABLE;

    public static Operator register(String symbol, int precedence, Operation operation) {
        Operator operator = new Operator(symbol, precedence, operation);
        if (OPERATORS.put(symbol, operator) != null) {
            throw new IllegalArgumentException("Attempting to register an already existing operator! '" + symbol + "'");
        }
        for (char symbolChar : symbol.toCharArray()) {
            OPERATOR_SYMBOLS.add(symbolChar);
        }
        LONGEST_OPERATOR = Math.max(LONGEST_OPERATOR, symbol.length());
        return operator;
    }

    public static boolean isOperator(String symbol) {
        return OPERATORS.containsKey(symbol);
    }

    public static Optional<Operator> getOperatorFor(String symbol) {
        return Optional.ofNullable(OPERATORS.get(symbol));
    }

    public static int maxOperatorLength() {
        return LONGEST_OPERATOR;
    }

    public static boolean isOperativeSymbol(char symbol) {
        return OPERATOR_SYMBOLS.contains(symbol);
    }

    public double compute(double argA, double argB) {
        return this.operation.compute(argA, argB);
    }

    @Override
    public int compareTo(Operator operator) {
        return Integer.compare(this.precedence, operator.precedence);
    }

    public boolean takesPrecedenceOver(Operator operator) {
        return this.compareTo(operator) > 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.symbol);
    }

    static {
        ADD = Operator.register("+", 1, Double::sum);
        SUB = Operator.register("-", 1, (a, b) -> a - b);
        MUL = Operator.register("*", 2, (a, b) -> a * b);
        DIV = Operator.register("/", 2, (a, b) -> b == 0.0 ? a : a / b);
        MOD = Operator.register("%", 2, (a, b) -> b == 0.0 ? a : a % b);
        POW = Operator.register("^", 3, Math::pow);
        AND = Operator.register("&&", 5, (a, b) -> a != 0.0 && b != 0.0 ? 1.0 : 0.0);
        OR = Operator.register("||", 5, (a, b) -> a != 0.0 || b != 0.0 ? 1.0 : 0.0);
        LT = Operator.register("<", 5, (a, b) -> a < b ? 1.0 : 0.0);
        LTE = Operator.register("<=", 5, (a, b) -> a <= b ? 1.0 : 0.0);
        GT = Operator.register(">", 5, (a, b) -> a > b ? 1.0 : 0.0);
        GTE = Operator.register(">=", 5, (a, b) -> a >= b ? 1.0 : 0.0);
        EQUAL = Operator.register("==", 5, (a, b) -> Math.abs(a - b) < 1.0E-5 ? 1.0 : 0.0);
        NOT_EQUAL = Operator.register("!=", 5, (a, b) -> Math.abs(a - b) >= 1.0E-5 ? 1.0 : 0.0);
        ASSIGN_VARIABLE = Operator.register("=", Integer.MAX_VALUE, (a, b) -> 0.0);
    }

    @FunctionalInterface
    public static interface Operation {
        public double compute(double var1, double var3);
    }
}

